package unitTest;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import netsdk.lib.CommonFunctions;
import netsdk.lib.DeviceSdk;
import netsdk.struct.LPNET_SDK_DEVICEINFO;
import netsdk.struct.NET_SDK_FACE_INFO_GROUP_ADD;
import netsdk.struct.NET_SDK_FACE_INFO_GROUP_DEL;
import netsdk.struct.NET_SDK_FACE_INFO_GROUP_ITEM;

import org.junit.Test;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class NET_SDK_FaceMatchOperate_Test {
    public static final int NET_SDK_FACE_INFO_GROUP_PROPERTY_ALLOW = 0;
    public static final int NET_SDK_FACE_INFO_GROUP_PROPERTY_REJECT = 1;
    public static final int NET_SDK_FACE_INFO_GROUP_PROPERTY_LIMITED = 2;

	@Test
	public void NET_SDK_GET_FACE_MATCH_SUPPORT_Test(){
		try {
			Boolean initResult = CommonFunctions.init();
			if(!initResult)
				return;
			
			LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
			NativeLong lUserID;
			lUserID = CommonFunctions.login(lpDeviceInfo);
	
			int dwOutBufferSize = 4;//实际的接受数据的结构体大小
			Pointer lpOutBuffer = new Memory(dwOutBufferSize); 
			IntByReference lpBytesReturned = new IntByReference();
			System.out.println("*********************NET_SDK_GET_FACE_MATCH_SUPPORT******************************");
			Boolean result = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 1, null, 0, lpOutBuffer, 4, lpBytesReturned);
	
			System.out.println("result:" + result);
			int isSupport = lpOutBuffer.getInt(0);
			System.out.println("isSupport:" + isSupport);

			// 释放内存
			Pointer p = lpDeviceInfo.getPointer();
			long peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);
			

			peer = Pointer.nativeValue(lpOutBuffer);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(lpOutBuffer, 0);
			
			
			
			
		} 
		catch (Throwable e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	


	@Test
	public void NET_SDK_GET_FACE_INFO_GROUP_LIST_Test() throws Throwable{
		Boolean initResult = CommonFunctions.init();
		if(!initResult)
			return;

		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		List<NET_SDK_FACE_INFO_GROUP_ITEM> ret = NET_SDK_GET_FACE_INFO_GROUP_LIST_Run(lUserID);

		// 释放内存
        Pointer p;
        long peer;
		p = lpDeviceInfo.getPointer();
		peer = Pointer.nativeValue(p);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(p, 0);
		
		for(NET_SDK_FACE_INFO_GROUP_ITEM item : ret){
			p = item.getPointer();
			peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);	
		}		
	}

	public static List<NET_SDK_FACE_INFO_GROUP_ITEM> NET_SDK_GET_FACE_INFO_GROUP_LIST_Run(NativeLong lUserID) throws Throwable{
		Boolean initResult = CommonFunctions.init();
		if(!initResult)
			return null;

		int max=100;
        NET_SDK_FACE_INFO_GROUP_ITEM[] sOut = new NET_SDK_FACE_INFO_GROUP_ITEM[max];
        for (int i = 0; i < max; i++) {
            sOut[i] = new NET_SDK_FACE_INFO_GROUP_ITEM();
        }
        Memory lpOutBuffer = new Memory(max * 100 * 1024);
        CommonFunctions.SetStructArrToPointerData(sOut, lpOutBuffer);
        IntByReference lpBytesReturned = new IntByReference();
        //Memory lpBytesReturned = new Memory(4);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 2, null, 0, lpOutBuffer, (int)lpOutBuffer.size(), lpBytesReturned);
		System.out.println("Result:" + bResult);
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }
        CommonFunctions.GetPointerDataToStructArr(lpOutBuffer, sOut);
        List<NET_SDK_FACE_INFO_GROUP_ITEM> result = new ArrayList<NET_SDK_FACE_INFO_GROUP_ITEM>();
        for (int i = 0; i < max; i++) {
            if (sOut[i].groupId > 0) {
            	System.out.println(String.format("获取目标组 guid:%s - groupId:%s - name:%s, ", new String(sOut[i].guid), sOut[i].groupId,
                        new String(sOut[i].name)));
            	result.add(sOut[i]);
            }
        }
        
		// 释放内存
        Pointer p;
        long peer;
		peer = Pointer.nativeValue(lpOutBuffer);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(lpOutBuffer, 0);
		
		
//		peer = Pointer.nativeValue(lpBytesReturned);
//		Native.free(peer);// 手动释放内存
//		Pointer.nativeValue(lpBytesReturned, 0);        
        return result;
	}
	
	@Test
	public void NET_SDK_ADD_FACE_INFO_GROUP_Test() throws Throwable{
		Boolean initResult = CommonFunctions.init();
		if(!initResult)
			return;
		
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		

		System.out.println("*********************NET_SDK_ADD_FACE_INFO_GROUP******************************");
        NET_SDK_FACE_INFO_GROUP_ADD sIn = new NET_SDK_FACE_INFO_GROUP_ADD();
        String groupName = "测试特征组1";
        try {
            System.arraycopy(groupName.getBytes("UTF-8"), 0, sIn.name, 0, groupName.getBytes("UTF-8").length);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sIn.property = NET_SDK_FACE_INFO_GROUP_PROPERTY_ALLOW;

        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
        IntByReference lpBytesReturned = new IntByReference();
        //Memory lpBytesReturned = new Memory(4);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 3, lpInBuffer,
                (int)lpInBuffer.size(), null, 0, lpBytesReturned);

		System.out.println("Result:" + bResult);
        
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }


		// 释放内存
        Pointer p;
        long peer;
		p = lpDeviceInfo.getPointer();
		peer = Pointer.nativeValue(p);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(p, 0);

		p = sIn.getPointer();
		peer = Pointer.nativeValue(p);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(p, 0);

		peer = Pointer.nativeValue(lpInBuffer);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(lpInBuffer, 0);
		
		
//		peer = Pointer.nativeValue(lpBytesReturned);
//		Native.free(peer);// 手动释放内存
//		Pointer.nativeValue(lpBytesReturned, 0);  
		
	}
	

	@Test
	public void NET_SDK_SET_FACE_INFO_GROUP_Test() throws Throwable{
		Boolean initResult = CommonFunctions.init();
		if(!initResult)
			return;
		
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		

		System.out.println("*********************NET_SDK_SET_FACE_INFO_GROUP******************************");
		List<NET_SDK_FACE_INFO_GROUP_ITEM> list = NET_SDK_GET_FACE_INFO_GROUP_LIST_Run(lUserID);
		if(list.size()==0){
			System.out.println("没有特征组");	
			return;
		}		

		NET_SDK_FACE_INFO_GROUP_ITEM toBeEditItem = list.get(0);
        String groupName = "测试特征组2";
        NET_SDK_FACE_INFO_GROUP_ITEM sIn = new NET_SDK_FACE_INFO_GROUP_ITEM();
        try {
            System.arraycopy(groupName.getBytes("UTF-8"), 0, sIn.name, 0, groupName.getBytes("UTF-8").length);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.arraycopy(toBeEditItem.guid, 0, sIn.guid, 0, toBeEditItem.guid.length);
        sIn.property = NET_SDK_FACE_INFO_GROUP_PROPERTY_ALLOW;
        sIn.enableAlarmSwitch = 1;
        sIn.groupId = toBeEditItem.groupId;
        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
        IntByReference lpBytesReturned = new IntByReference();
        //Memory lpBytesReturned = new Memory(4);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 4, lpInBuffer,
                (int) lpInBuffer.size(), null, 0, lpBytesReturned);

		System.out.println("Result:" + bResult);
		
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }

		// 释放内存
        Pointer p;
        long peer;

		for (NET_SDK_FACE_INFO_GROUP_ITEM item : list) {
			p = item.getPointer();
			peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);			
		}	
        
		p = lpDeviceInfo.getPointer();
		peer = Pointer.nativeValue(p);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(p, 0);
		
		p = sIn.getPointer();
		peer = Pointer.nativeValue(p);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(p, 0);

		peer = Pointer.nativeValue(lpInBuffer);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(lpInBuffer, 0);
		
		
//		peer = Pointer.nativeValue(lpBytesReturned);
//		Native.free(peer);// 手动释放内存
//		Pointer.nativeValue(lpBytesReturned, 0);  
	}
	

	

	@Test
	public void NET_SDK_DEL_FACE_INFO_GROUP_Test() throws Throwable{
		Boolean initResult = CommonFunctions.init();
		if(!initResult)
			return;
		
		LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo = new LPNET_SDK_DEVICEINFO.ByReference();
		NativeLong lUserID = CommonFunctions.login(lpDeviceInfo);
		

		System.out.println("*********************NET_SDK_SET_FACE_INFO_GROUP******************************");
		List<NET_SDK_FACE_INFO_GROUP_ITEM> list = NET_SDK_GET_FACE_INFO_GROUP_LIST_Run(lUserID);
		if(list.size()==0){
			System.out.println("没有特征组");	
			return;
		}

		NET_SDK_FACE_INFO_GROUP_ITEM toBeEditItem = list.get(0);
        NET_SDK_FACE_INFO_GROUP_DEL sIn = new NET_SDK_FACE_INFO_GROUP_DEL();
        System.arraycopy(toBeEditItem.guid, 0, sIn.guid, 0, toBeEditItem.guid.length);
        Memory lpInBuffer = new Memory(sIn.size());
        CommonFunctions.SetStructDataToPointer(sIn, lpInBuffer, 0);
        IntByReference lpBytesReturned = new IntByReference();
        //Memory lpBytesReturned = new Memory(4);
        boolean bResult = DeviceSdk.INSTANCE.NET_SDK_FaceMatchOperate(lUserID, 5, lpInBuffer,
                (int) lpInBuffer.size(), null, 0, lpBytesReturned);

		System.out.println("Result:" + bResult);
		
        if (!bResult) {
            throw new RuntimeException("NET_SDK_FaceMatchOperate 错误:" + CommonFunctions.getError());
        }

		// 释放内存
        Pointer p;
        long peer;

		for (NET_SDK_FACE_INFO_GROUP_ITEM item : list) {
			p = item.getPointer();
			peer = Pointer.nativeValue(p);
			Native.free(peer);// 手动释放内存
			Pointer.nativeValue(p, 0);			
		}	
        
		p = lpDeviceInfo.getPointer();
		peer = Pointer.nativeValue(p);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(p, 0);
		
		p = sIn.getPointer();
		peer = Pointer.nativeValue(p);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(p, 0);

		peer = Pointer.nativeValue(lpInBuffer);
		Native.free(peer);// 手动释放内存
		Pointer.nativeValue(lpInBuffer, 0);
		
		
//		peer = Pointer.nativeValue(lpBytesReturned);
//		Native.free(peer);// 手动释放内存
//		Pointer.nativeValue(lpBytesReturned, 0); 
	}

}
